/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.eui;

import ibm.nways.jdm.JmaColors;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.eui.EditableTableDataModel;
import ibm.nways.jdm.eui.EuiGridController;
import ibm.nways.jdm.eui.EuiGridEvent;
import ibm.nways.jdm.eui.EuiGridListener;
import ibm.nways.jdm.eui.JDMInput;
import ibm.nways.jdm.eui.TableColumn;
import ibm.nways.jdm.eui.TableColumnModel;
import ibm.nways.jdm.eui.TableModelEvent;
import ibm.nways.jdm.eui.TableModelListener;
import ibm.nways.jdm.eui.myGrid;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import mlsoft.mct.MlGridEvent;
import mlsoft.mct.MlGridListener;
import mlsoft.mct.MlIconMaker;
import mlsoft.mct.MlResources;

public class EuiGrid
extends Panel
implements MlGridListener,
JDMInput,
TableModelListener,
ActionListener {
    private Vector listeners;
    private int gridWidth;
    private int gridHeight;
    private int[] columnWidths;
    private int columns;
    private int width;
    private int rows;
    private int toprow;
    private int bottomrow;
    private FontMetrics metrics;
    private myGrid grid;
    private EuiGridController controller;
    private EditableTableDataModel table;
    private TableColumnModel columnIds;
    private boolean numColumnsKnown = false;
    private boolean sizefixed = false;
    private Image statusOn;
    private Image statusOff;
    private Label message;
    private boolean defaultMonitor = true;
    private boolean withStatus = false;
    private int charWidth;
    private boolean debug = false;
    private static final String STATUSHEADER = "Status";
    private static final int MAXCOLWIDTH = 35;

    public EuiGrid() {
        this(null, null);
    }

    public EuiGrid(EditableTableDataModel editableTableDataModel) {
        this(editableTableDataModel, null);
    }

    public EuiGrid(EditableTableDataModel editableTableDataModel, TableColumnModel tableColumnModel) {
        this(editableTableDataModel, tableColumnModel, false);
    }

    public EuiGrid(EditableTableDataModel editableTableDataModel, TableColumnModel tableColumnModel, boolean bl) {
        this.withStatus = bl;
        if (editableTableDataModel != null) {
            this.table = editableTableDataModel;
            this.table.addTableModelListener(this);
        }
        this.columnIds = tableColumnModel;
        this.makeImages();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.message = new Label("                                                                                                               ");
        this.message.setFont(new Font("PLAIN", 2, 12));
        this.message.setForeground(JmaColors.textText);
        this.message.setBackground(JmaColors.background);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(this.message, gridBagConstraints);
        this.add(this.message);
        this.grid = new myGrid(this);
        this.grid.enable(new Ml31Key());
        if (this.debug) {
            System.out.println("Grid constructed");
        }
        this.controller = new EuiGridController(tableColumnModel);
        this.controller.addActionListener(this);
        MlResources mlResources = new MlResources();
        mlResources.add("horizontalSizePolicy", 1);
        mlResources.add("verticalSizePolicy", 1);
        mlResources.add("headingRows", 1);
        mlResources.add("autoSelect", false);
        mlResources.add("selectionPolicy", 0);
        mlResources.add("useAverageFontWidth", false);
        mlResources.add("allowColumnResize", true);
        this.grid.setValues(mlResources);
        if (this.debug) {
            System.out.println("Grid initial resources set");
        }
        mlResources.clear();
        mlResources.add("rowType", "CONTENT");
        mlResources.add("cellDefaults", true);
        mlResources.add("cellAlignment", "ALIGNMENT_CENTER");
        mlResources.add("cellBackground", new Color(0, 0, 75));
        mlResources.add("cellForeground", Color.white);
        mlResources.add("columnSizePolicy", 1);
        mlResources.add("highlightThickness", 0);
        this.grid.setValues(mlResources);
        if (this.debug) {
            System.out.println("Grid secondary resources set");
        }
        this.setHeadings();
        mlResources.clear();
        mlResources.add("cellDefaults", true);
        mlResources.add("column", 0);
        mlResources.add("cellTopBorderType", 0);
        mlResources.add("cellBottomBorderType", 0);
        mlResources.add("cellType", 1);
        this.grid.setValues(mlResources);
        this.grid.addMlGridListener(this);
        if (this.debug) {
            System.out.println("Attached to grid as listener");
        }
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = -1;
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(this.grid, gridBagConstraints2);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 0;
        gridBagConstraints3.weightx = 0.0;
        gridBagConstraints3.weighty = 0.0;
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = -1;
        gridBagConstraints3.gridwidth = 0;
        gridBagConstraints3.gridheight = 1;
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.insets = new Insets(3, 0, 0, 0);
        gridBagLayout.setConstraints(this.controller, gridBagConstraints3);
        this.add(this.grid);
        this.add(this.controller);
        if (this.debug) {
            System.out.println("Layout complete in constructor");
        }
    }

    public void setColumnWidths() {
        if (this.debug) {
            System.out.println("Entering setColumnWidths()");
        }
        this.getBounds();
        int n = this.grid.getColumns();
        int n2 = this.grid.getRows();
        MlResources mlResources = new MlResources();
        this.columnWidths = new int[n];
        int n3 = 0;
        while (n3 < n) {
            this.columnWidths[n3] = ((String)this.grid.getCellValue(0, 0, 1, n3, "cellString")).length() + 2;
            int n4 = 0;
            while (n4 < n2) {
                String string = (String)this.grid.getCellValue(n4, n3, "cellString");
                if (string != null) {
                    this.columnWidths[n3] = Math.max(this.columnWidths[n3], string.length() + 2);
                }
                ++n4;
            }
            this.columnWidths[n3] = Math.min(this.columnWidths[n3], 40);
            this.width += this.columnWidths[n3];
            mlResources.clear();
            mlResources.add("column", n3);
            mlResources.add("columnSizePolicy", 1);
            mlResources.add("columnWidth", this.columnWidths[n3]);
            this.grid.setValues(mlResources);
            ++n3;
        }
        this.grid.doLayout();
        if (this.debug) {
            System.out.println("Exiting setColumnWidths()");
        }
    }

    public void setHeadings(String string) {
    }

    public void setHeadings() {
        if (this.debug) {
            System.out.println("Entering setHeadings()");
        }
        if (this.columnIds != null) {
            Object object;
            StringBuffer stringBuffer = new StringBuffer(STATUSHEADER);
            this.columns = this.columnIds.getColumnCount() + 1;
            this.columnWidths = new int[this.columns];
            if (this.columnIds != null) {
                object = this.columnIds.getColumns();
                while (object.hasMoreElements()) {
                    String string = (String)((TableColumn)object.nextElement()).getHeaderValue();
                    stringBuffer.append('|').append(string);
                }
            }
            object = new MlResources();
            this.grid.setValue("layoutFrozen", true);
            this.grid.addColumns(1, -1, this.columns);
            this.grid.setStrings(0, 0, 1, 0, stringBuffer.toString());
            this.grid.setValue("layoutFrozen", false);
            ((MlResources)object).clear();
            ((MlResources)object).add("rowType", "HEADING");
            ((MlResources)object).add("row", 0);
            ((MlResources)object).add("cellBackground", SystemColor.textHighlight);
            ((MlResources)object).add("cellForeground", SystemColor.textHighlightText);
            this.grid.setValues((MlResources)object);
            this.width = 0;
            int n = 0;
            Enumeration enumeration = this.columnIds.getColumns();
            while (enumeration.hasMoreElements()) {
                int n2 = n == 0 ? (this.withStatus ? STATUSHEADER.length() : 0) : ((String)((TableColumn)enumeration.nextElement()).getHeaderValue()).length() + 2;
                this.columnWidths[n] = n2;
                this.width += n2;
                if (this.debug) {
                    System.out.println("Setting width of col=" + n + " to " + this.columnWidths[n]);
                }
                ((MlResources)object).clear();
                ((MlResources)object).add("column", n);
                ((MlResources)object).add("columnSizePolicy", 1);
                ((MlResources)object).add("columnWidth", this.columnWidths[n]);
                this.grid.setValues((MlResources)object);
                ++n;
            }
        }
        if (this.debug) {
            System.out.println("Exiting setHeadings()");
        }
    }

    private void adjustColumnWidth(int n, String string) {
        if (n < this.columns && n > 0) {
            int n2 = string.length() + 3;
            if (n2 > this.columnWidths[n]) {
                MlResources mlResources = new MlResources();
                this.columnWidths[n] = n2;
                mlResources.clear();
                mlResources.add("column", n);
                mlResources.add("columnSizePolicy", 1);
                mlResources.add("columnWidth", n2);
                this.grid.setValues(mlResources);
                return;
            }
        } else {
            System.err.println("Error: column index out of bounds");
        }
    }

    protected int getMaxWidth() {
        int n = 0;
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            if (this.charWidth == 0) {
                FontMetrics fontMetrics = graphics.getFontMetrics();
                this.charWidth = fontMetrics.charWidth('W');
            }
            int n2 = 0;
            while (n2 < this.columns) {
                n += this.columnWidths[n2] * this.charWidth;
                ++n2;
            }
        }
        return n;
    }

    protected void setRowContents(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(255);
        boolean bl = true;
        boolean bl2 = true;
        if (this.debug) {
            System.out.println("setRowContents()-before: grid row=" + n + " table row =" + n2 + " rows=" + this.rows + " top=" + this.toprow + " bot=" + this.bottomrow + " count=" + this.table.getRowCount());
        }
        try {
            Object object;
            Object object2;
            int n3 = 1;
            Enumeration enumeration = this.columnIds.getColumns();
            while (enumeration.hasMoreElements()) {
                object2 = (TableColumn)enumeration.nextElement();
                object = (String)((TableColumn)object2).getIdentifier();
                int n4 = ((TableColumn)object2).getType();
                Object object3 = this.table.getValueAt(object, n2);
                stringBuffer.append('|');
                if (object3 != null) {
                    String string = object3.toString();
                    if (n4 == 16) {
                        try {
                            int n5 = Integer.parseInt(string);
                            string = this.table.translateEnum((String)object, n5);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                    if (string.length() > 35) {
                        string = String.valueOf(string.substring(0, 35)) + " ...";
                    }
                    stringBuffer.append(string);
                    this.adjustColumnWidth(n3, string);
                    bl2 = false;
                }
                bl = false;
                ++n3;
            }
            if (!this.sizefixed) {
                if (bl2) {
                    this.sizefixed = true;
                } else {
                    this.grid.addRows(1, -1, 1);
                    ++this.rows;
                    ++this.bottomrow;
                    this.grid.setStrings(n, stringBuffer.toString());
                }
            } else {
                this.grid.setStrings(n, stringBuffer.toString());
            }
            if (!bl2) {
                object2 = this.table.isMonitored(n2) ? this.statusOn : this.statusOff;
                object = new MlResources();
                ((MlResources)object).clear();
                ((MlResources)object).add("row", n);
                ((MlResources)object).add("column", 0);
                ((MlResources)object).add("cellImage", object2);
                this.grid.setValues((MlResources)object);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        if (this.debug) {
            System.out.println("setRowContents()-after: grid row=" + n + " table row =" + n2 + " rows=" + this.rows + " top=" + this.toprow + " bot=" + this.bottomrow + " count=" + this.table.getRowCount());
        }
    }

    public void threadRefresh() {
        if (this.columnIds != null) {
            int n = 0;
            while (n < this.rows || !this.sizefixed) {
                this.setRowContents(n, this.toprow + n);
                ++n;
            }
            this.bottomrow = this.toprow + this.rows - 1;
        }
    }

    public void refresh() {
        if (this.columnIds != null) {
            int n = 0;
            while (n < this.rows || !this.sizefixed) {
                this.setRowContents(n, this.toprow + n);
                ++n;
            }
            this.bottomrow = this.toprow + this.rows - 1;
        }
        this.doLayout();
    }

    public void setVisibleRows(int n) {
        this.grid.deleteRows(1, 0, this.rows);
        this.grid.addRows(1, -1, n);
        this.rows = n;
        this.sizefixed = true;
    }

    public void addRows(int n) {
        this.setVisibleRows(n);
    }

    public void deleteAllRows() {
        this.grid.deleteAllRows(1);
    }

    public void deselectAllRows() {
        this.grid.deselectAllRows(false);
    }

    public void deselectAllRows(boolean bl) {
        this.deselectAllRows();
    }

    public void selectRow(int n) {
        this.grid.selectRow(n, false);
    }

    public void selectRow(int n, boolean bl) {
        this.selectRow(n);
    }

    public void deselectRow(int n) {
        this.grid.deselectRow(n, false);
    }

    public void setRowContents(int n, String string) {
        this.grid.setStrings(n, string);
    }

    public void setStrings(int n, String string) {
        this.setRowContents(n, string);
    }

    public void onGridEvent(MlGridEvent mlGridEvent) {
        if (mlGridEvent.getType() == 5014) {
            if (this.debug) {
                System.out.println("Cell " + mlGridEvent.getRow() + "," + mlGridEvent.getColumn() + " selected");
            }
            EuiGridEvent euiGridEvent = new EuiGridEvent(this, 2001, mlGridEvent.getRow() + this.toprow, mlGridEvent.getColumn());
            if (mlGridEvent.getRowType() == 0) {
                if (this.debug) {
                    System.out.println("Heading selected, column = " + mlGridEvent.getColumn());
                }
                if (mlGridEvent.getColumn() == 0) {
                    this.defaultMonitor = !this.defaultMonitor;
                    Image image = this.defaultMonitor ? this.statusOn : this.statusOff;
                    MlResources mlResources = new MlResources();
                    mlResources.clear();
                    mlResources.add("column", 0);
                    mlResources.add("rowRangeStart", 0);
                    mlResources.add("rowRangeEnd", Math.min(this.table.getRowCount() - this.toprow - 1, this.rows - 1));
                    mlResources.add("cellImage", image);
                    this.grid.setValues(mlResources);
                    if (this.debug) {
                        System.out.println("Setting monitoring flag for all rows to " + (image == this.statusOn));
                    }
                    this.table.setMonitoring(-1, this.defaultMonitor);
                    return;
                }
            } else {
                if (mlGridEvent.getColumn() == 0) {
                    Image image = (Image)this.grid.getCellValue(mlGridEvent.getRow(), 0, "cellImage");
                    image = image == null ? this.statusOn : this.statusOff;
                    MlResources mlResources = new MlResources();
                    mlResources.clear();
                    mlResources.add("row", mlGridEvent.getRow());
                    mlResources.add("column", 0);
                    mlResources.add("cellImage", image);
                    this.grid.setValues(mlResources);
                    if (this.debug) {
                        System.out.println("Setting monitoring flag on row " + (mlGridEvent.getRow() + this.toprow) + " to " + (image == this.statusOn));
                    }
                    this.table.setMonitoring(mlGridEvent.getRow() + this.toprow, image == this.statusOn);
                    return;
                }
                if (this.listeners != null && mlGridEvent.getRow() + this.toprow < this.table.getRowCount()) {
                    int n = 0;
                    while (n < this.listeners.size()) {
                        EuiGridListener euiGridListener = (EuiGridListener)this.listeners.elementAt(n);
                        euiGridListener.onEuiGridEvent(euiGridEvent);
                        ++n;
                    }
                }
            }
        }
    }

    public synchronized void addEuiGridListener(EuiGridListener euiGridListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(euiGridListener);
    }

    public synchronized void removeEuiGridListener(EuiGridListener euiGridListener) {
        if (this.listeners != null) {
            this.listeners.removeElement(euiGridListener);
        }
    }

    public Object getValue() {
        return new Vector();
    }

    public String toString() {
        return "Table";
    }

    public void setValue(Object object) {
    }

    public void setValue(String string) {
    }

    public boolean isValidValue() {
        return true;
    }

    public void tableCellChanged(TableModelEvent tableModelEvent) {
    }

    public void tableRowsChanged(TableModelEvent tableModelEvent) {
    }

    public void tableRowsRemoved(TableModelEvent tableModelEvent) {
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
    }

    public void tableRowsInserted(TableModelEvent tableModelEvent) {
        int[] nArray = tableModelEvent.getRowIndices();
        if (this.debug) {
            System.out.println("Row Inserted Event received for row " + nArray[0]);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        if (this.debug) {
            System.out.println("EuiGrid::actionPerformed() called ...");
        }
        if ((string = actionEvent.getActionCommand()).equals("down")) {
            if (this.table.knownBottom()) {
                if (this.bottomrow < this.table.getRowCount()) {
                    ++this.bottomrow;
                    ++this.toprow;
                    this.grid.moveRows(0, 1, this.rows - 1);
                    this.setRowContents(this.rows - 1, this.bottomrow);
                    return;
                }
            } else {
                ++this.bottomrow;
                ++this.toprow;
                this.grid.moveRows(0, 1, this.rows - 1);
                this.setRowContents(this.rows - 1, this.bottomrow);
            }
            return;
        }
        if (string.equals("up")) {
            if (this.toprow > 0) {
                --this.bottomrow;
                --this.toprow;
                this.grid.moveRows(1, 0, this.rows - 1);
                this.setRowContents(0, this.toprow);
                return;
            }
        } else {
            if (string.equals("top")) {
                this.toprow = 0;
                this.setInitialRow(null);
                this.refresh();
                return;
            }
            if (string.equals("bottom")) {
                this.toprow = Math.max(0, this.table.getRowCount() - this.rows + 1);
                this.refresh();
                return;
            }
            if (string.equals("pagedown")) {
                this.toprow = this.table.knownBottom() ? Math.min(this.bottomrow, Math.max(0, this.table.getRowCount() - this.rows + 1)) : this.bottomrow;
                this.refresh();
                return;
            }
            if (string.equals("pageup")) {
                if (this.toprow != 0) {
                    this.toprow = Math.max(0, this.toprow - this.rows + 1);
                    this.refresh();
                    return;
                }
            } else if (string.equals("find")) {
                ModelInfo modelInfo = this.controller.getInput();
                this.toprow = 0;
                this.setInitialRow(modelInfo);
                this.refresh();
            }
        }
    }

    public void scrollToTop() {
        this.toprow = 0;
        this.setInitialRow(null);
    }

    public void setInitialRow(ModelInfo modelInfo) {
        this.table.setTopRow(modelInfo);
        if (modelInfo == null) {
            this.message.setText("                                           ");
            this.message.invalidate();
            return;
        }
        this.message.setText("... starting at row " + this.indexString(modelInfo));
        this.message.invalidate();
    }

    public String indexString(ModelInfo modelInfo) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        Enumeration enumeration = this.columnIds.getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = (TableColumn)enumeration.nextElement();
            if (!tableColumn.getIsIndex()) continue;
            String string = (String)tableColumn.getIdentifier();
            if (!bl) {
                stringBuffer.append(',');
            }
            stringBuffer.append(modelInfo.get(string).toString());
            bl = false;
        }
        return stringBuffer.toString();
    }

    public void makeImages() {
        MlIconMaker mlIconMaker = new MlIconMaker();
        mlIconMaker.setDimensions(12, 12);
        mlIconMaker.setColor('B', -1);
        mlIconMaker.setPixels("            ");
        mlIconMaker.setPixels("           B");
        mlIconMaker.setPixels("          BB");
        mlIconMaker.setPixels("         BB ");
        mlIconMaker.setPixels("        BB  ");
        mlIconMaker.setPixels("  B    BB   ");
        mlIconMaker.setPixels(" BB   BBB   ");
        mlIconMaker.setPixels("  BB BBB    ");
        mlIconMaker.setPixels("   BBBBB    ");
        mlIconMaker.setPixels("    BBB     ");
        mlIconMaker.setPixels("     BB     ");
        mlIconMaker.setPixels("            ");
        this.statusOn = mlIconMaker.createImage(this);
        this.statusOff = null;
    }

    public boolean ignoreValue() {
        return false;
    }
}

